<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';

$id_modulo = isset($_GET['id_modulo']) ? (int)$_GET['id_modulo'] : 0;
if ($id_modulo <= 0) { http_response_code(400); echo json_encode([]); exit; }

$pdo = pdo_conn();

/* Tu tabla: resultados_aprendizaje (id, id_modulo, descripcion)
   Genero un "codigo" sintético: 'RA ' + id  (opcional) */
$sql = "SELECT 
          id,
          descripcion,
          CONCAT('RA ', id) AS codigo
        FROM resultados_aprendizaje
        WHERE id_modulo = :m
        ORDER BY id";
$st = $pdo->prepare($sql);
$st->execute([':m'=>$id_modulo]);
echo json_encode($st->fetchAll(PDO::FETCH_ASSOC), JSON_UNESCAPED_UNICODE);
