<?php
// modulos_list.php — devuelve lista simple de módulos {id, nombre}
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

try {
    require_once __DIR__ . '/includes/db.php';
    /** @var PDO $db */
    $db = isset($conn) && $conn instanceof PDO ? $conn : (isset($pdo) && $pdo instanceof PDO ? $pdo : null);
    if (!$db) throw new RuntimeException('Sin PDO');

    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $st = $db->query("SELECT id, nombre FROM modulos ORDER BY nombre ASC");
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
    echo json_encode([]);
}
