


<?php
session_start();
require_once 'includes/db.php';


$_SESSION['usuario'];

$mensaje = '';

// Procesar formulario (Alta o Edición)
if (!empty($_POST['nombre'])) {
    $nombre = trim($_POST['nombre']);

    if (isset($_POST['id_editar'])) {
        // Editar módulo existente
        $idEditar = (int)$_POST['id_editar'];

        try {
            $stmt = $conn->prepare("UPDATE modulos SET nombre = :nombre WHERE id = :id");
            $stmt->bindParam(':nombre', $nombre);
            $stmt->bindParam(':id', $idEditar, PDO::PARAM_INT);
            $stmt->execute();
            $mensaje = "Módulo actualizado correctamente.";
            header("Location: modulos.php"); // Evitar reenvío del formulario
            exit;
        } catch (PDOException $e) {
            $mensaje = "Error al actualizar módulo: " . $e->getMessage();
        }
    } else {
        // Alta de nuevo módulo
        try {
            $stmt = $conn->prepare("INSERT INTO modulos (nombre) VALUES (:nombre)");
            $stmt->bindParam(':nombre', $nombre);
            $stmt->execute();
            $mensaje = "Módulo añadido correctamente.";
        } catch (PDOException $e) {
            $mensaje = "Error al insertar módulo: " . $e->getMessage();
        }
    }
}
?>

<h2>Gestión de Módulos Profesionales</h2>

<?php if ($mensaje): ?>
    <p><?php echo $mensaje; ?></p>
<?php endif; ?>

<?php
// Si viene la variable editar, mostramos el formulario de edición
if (isset($_GET['editar'])):
    $idEditar = (int)$_GET['editar'];

    try {
        $stmt = $conn->prepare("SELECT * FROM modulos WHERE id = :id");
        $stmt->bindParam(':id', $idEditar, PDO::PARAM_INT);
        $stmt->execute();

        $modulo = $stmt->fetch();

        if ($modulo):
?>
        <h3>Editar Módulo</h3>
        <form method="post">
            <input type="hidden" name="id_editar" value="<?php echo $modulo['id']; ?>">
            <label for="nombre">Nuevo Nombre:</label><br>
            <input type="text" name="nombre" id="nombre" size="70" value="<?php echo $modulo['nombre']; ?>" required><br><br>
            <input type="submit" value="Actualizar">
        </form>
<?php
        else:
            echo "<p>Módulo no encontrado.</p>";
        endif;
    } catch (PDOException $e) {
        echo "Error al buscar módulo: " . $e->getMessage();
    }
else:
?>

<h3>Alta de Nuevo Módulo</h3>
<form method="post">
    <label for="nombre">Nombre del Módulo:</label><br>
    <input type="text" name="nombre" id="nombre" size="70" required><br><br>
    <input type="submit" value="Guardar">
</form>

<?php endif; ?>

<hr>

<h3>Listado de Módulos</h3>
<ul>
<?php
try {
    $stmt = $conn->query("SELECT * FROM modulos ORDER BY id DESC");
    echo "<table>";
    while ($row = $stmt->fetch()) {
        echo "<tr><td><a href='g_modulo.php?id={$row['id']}'> {$row['nombre']} </a>
              
              </td></tr>";
    }
       echo "</table>";
} catch (PDOException $e) {
    echo "Error al obtener módulos: " . $e->getMessage();
}
?>
</ul>
