<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db_pdo.php';
try {
  $pdo = pdo_conn();
  $input = json_decode(file_get_contents('php://input'), true) ?: [];
  $id = $input['id'] ?? null;

  $data = [
    'id_modulo'   => (int)$input['id_modulo'],
    'anno'        => trim((string)$input['anno']),
    'trimestre'   => (int)$input['trimestre'],
    'titulo'      => trim((string)$input['titulo']),
    'descripcion' => $input['descripcion'] ?? null,
    'fecha'       => $input['fecha'] ?: null,
    'ponderacion' => isset($input['ponderacion']) ? (int)$input['ponderacion'] : null
  ];
  $criterios = $input['criterios'] ?? [];
  $alumno_asignar = isset($input['id_alumno_asignar']) ? (int)$input['id_alumno_asignar'] : 0;

  if (!$data['id_modulo'] || !$data['anno'] || !$data['trimestre'] || !$data['titulo']) {
    echo json_encode(['ok'=>false,'error'=>'Faltan campos obligatorios']); exit;
  }

  if ($id) {
    $sql = "UPDATE instrumentos SET id_modulo=:id_modulo, anno=:anno, trimestre=:trimestre,
            titulo=:titulo, descripcion=:descripcion, fecha=:fecha, ponderacion=:ponderacion
            WHERE id=:id";
    $data['id']=$id;
  } else {
    $sql = "INSERT INTO instrumentos (id_modulo, anno, trimestre, titulo, descripcion, fecha, ponderacion)
            VALUES (:id_modulo,:anno,:trimestre,:titulo,:descripcion,:fecha,:ponderacion)";
  }

  $pdo->beginTransaction();
  $st = $pdo->prepare($sql); $st->execute($data);
  $instrumento_id = $id ? (int)$id : (int)$pdo->lastInsertId();

  // Reemplazar criterios
  $pdo->prepare("DELETE FROM instrumento_criterios WHERE id_instrumento=:i")->execute([':i'=>$instrumento_id]);
  if (!empty($criterios)) {
    $ins = $pdo->prepare("INSERT INTO instrumento_criterios (id_instrumento, id_criterio) VALUES (:i,:c)");
    foreach ($criterios as $cid) $ins->execute([':i'=>$instrumento_id, ':c'=>(int)$cid]);
  }

  // Si es nuevo y hay alumno, asignar al alumno con nota NULL (o mantener si ya existe)
  if (!$id && $alumno_asignar>0) {
    $pdo->prepare("INSERT INTO instrumentos_notas (id_instrumento,id_alumno,nota)
                   VALUES (:i,:a,NULL) ON DUPLICATE KEY UPDATE id_instrumento=id_instrumento")
        ->execute([':i'=>$instrumento_id, ':a'=>$alumno_asignar]);
  }

  $pdo->commit();
  echo json_encode(['ok'=>true,'id'=>$instrumento_id]);
} catch (Throwable $e) {
  if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
  error_log('[instrumentos_save] '.$e->getMessage());
  echo json_encode(['ok'=>false,'error'=>'Error en servidor']);
}

