// instrumentos_evaluacion.js
(function($, window, document){
  'use strict';

  // ---- Estado global y caché de etiquetas (se mantienen aunque cambies de RA) ----
  window.__criteriosSel   ||= new Set();   // IDs seleccionados como strings
  window.__criteriosCache ||= new Map();   // id -> etiqueta legible

  const criteriosSel   = window.__criteriosSel;
  const criteriosCache = window.__criteriosCache;

  // ---- Helpers ----
  const option = (label, value) => `<option value="${value}">${label}</option>`;
  const annoActual = () => ($('#f_anno').val()||'').trim();
  const idModulo   = () => parseInt($('#f_modulo').val(), 10) || 0;
// Si el campo llega vacío por cualquier motivo, auto-poner curso escolar actual
(function ensureDefaultAnno(){
  const $a = $('#f_anno');
  if(($a.val()||'').trim()) return;
  const d = new Date();                   // local del navegador
  const y = d.getFullYear();
  const m = d.getMonth() + 1;             // 1..12
  const def = (m >= 9) ? `${y}/${y+1}` : `${y-1}/${y}`;
  $a.val(def);
})();

  // ---- Cargar RA del módulo ----
  function cargarRA(){
    const idm = idModulo();
    const $ra = $('#sel_ra').empty();
    if(!idm){ return; }
    $.getJSON('ra_list.php', { id_modulo:idm })
      .done(rows=>{
        rows.forEach(r=>{
          const etiqueta = r.descripcion ? `${r.codigo} · ${r.descripcion}` : (r.codigo || `RA ${r.id}`);
          $ra.append(option(etiqueta, r.id));
        });
        $ra.trigger('change');
      })
      .fail(()=>{ $ra.append('<option value="">(Error cargando RA)</option>'); });
  }

  // ---- Cargar alumnos matriculados (módulo/año) ----

function cargarAlumnos(){
  const a   = ($('#f_anno').val()||'').trim();
  const idm = parseInt($('#f_modulo').val(),10) || 0;
  const $box = $('#alumnos_checks').empty();

  if(!idm || !a){
    $box.html('<div class="muted">Selecciona módulo y año.</div>');
    return;
  }

  $.getJSON('alumnos_matriculados_list.php', { id_modulo:idm, anno:a })
    .done(rows=>{
      if (!Array.isArray(rows) || rows.length===0){
        $box.html('<div class="muted">No hay alumnos matriculados para este módulo/año.</div>');
        return;
      }
      const frag = document.createDocumentFragment();
      rows.forEach(al=>{
        const id = al.id;
        const nombre = [al.nombre, al.apellidos || ((al.apellido1||'')+' '+(al.apellido2||''))]
                        .filter(Boolean).join(' ');
        const div = document.createElement('div');
        div.className = 'row';
        div.innerHTML = `
          <label>
            <input type="checkbox" class="al_chk" value="${id}">
            <span>${nombre} <span class="muted">#${id}</span></span>
          </label>`;
        frag.appendChild(div);
      });
      $('#alumnos_checks')[0].appendChild(frag);

      // Si “asignar a todos” está activo, deshabilitamos los checks
      const all = $('#i_asignar_todos').is(':checked');
      $('#alumnos_checks .al_chk').prop('disabled', all);
    })
    .fail((xhr)=>{
      console.error('[cargarAlumnos] ERROR', xhr.status, xhr.responseText);
      $box.html('<div class="muted">Error cargando alumnos: '+(xhr.responseText||xhr.status)+'</div>');
    });
}







$('#f_modulo').on('change', ()=>{ /* …otras cargas… */ cargarAlumnos(); });
$('#f_anno').on('change', cargarAlumnos);

$('#i_asignar_todos').on('change', function(){
  $('#sel_alumnos').prop('disabled', $(this).is(':checked'));
});


  // ---- Cargar criterios disponibles a partir de RA seleccionados ----
  function cargarCriteriosDisponibles(){
    const idm = idModulo();
    const ras = ($('#sel_ra').val()||[]).map(Number);
    const $av = $('#sel_criterios_av').empty();
    if(!idm || ras.length===0){ return; }

    $.ajax({
      url:'criterios_list.php',
      data:{ id_modulo:idm, ra:ras },
      traditional:true,
      dataType:'json'
    }).done(rows=>{
      rows.forEach(r=>{
        const id = String(r.id);
        const etiqueta = `${r.codigo_ra} · ${r.criterio} (v=${r.valor})`;
        // guarda/actualiza en cache
        criteriosCache.set(id, etiqueta);
        // si NO está seleccionado, muéstralo en disponibles
        if(!criteriosSel.has(id)){
          $av.append(new Option(etiqueta, id));
        }
      });
      aplicarFiltroDisponibles();
    });
  }

  // ---- Pintar la lista derecha según el Set (acumula y respeta el orden de inserción) ----
  function renderSeleccionados(){
    const $sel = $('#sel_criterios_sel');
    $sel.empty();
    criteriosSel.forEach(id=>{
      const etiqueta = criteriosCache.get(id) || `Criterio #${id}`;
      $sel.append(new Option(etiqueta, id));
    });
  }

  // ---- Filtro cliente para la lista izquierda ----
  function aplicarFiltroDisponibles(){
    const q = ($('#filtro_av').val()||'').toLowerCase();
    $('#sel_criterios_av option').each(function(){
      const show = $(this).text().toLowerCase().includes(q);
      $(this).toggle(show);
    });
  }

  // ---- Mover entre listas (sin repintar completo) ----
  function addSeleccionados(){
    const $av = $('#sel_criterios_av');
    const $sel = $('#sel_criterios_sel');
    const $opts = $av.find('option:selected');
    if(!$opts.length) return;

    $opts.each(function(){
      const id = String(this.value);
      const etiqueta = this.text || criteriosCache.get(id) || `Criterio #${id}`;
      criteriosSel.add(id);
      criteriosCache.set(id, etiqueta);
      $sel.append(new Option(etiqueta, id)); // lo añade al final
      $(this).remove();                      // lo quita de disponibles
    });
  }

  function addTodos(){
    const $av = $('#sel_criterios_av');
    const $sel = $('#sel_criterios_sel');
    const $opts = $av.find('option');
    if(!$opts.length) return;

    $opts.each(function(){
      const id = String(this.value);
      const etiqueta = this.text || criteriosCache.get(id) || `Criterio #${id}`;
      criteriosSel.add(id);
      criteriosCache.set(id, etiqueta);
      $sel.append(new Option(etiqueta, id));
    });
    $av.empty();
  }

  function removeSeleccionados(){
    const $av  = $('#sel_criterios_av');
    const $sel = $('#sel_criterios_sel');
    const $opts = $sel.find('option:selected');
    if(!$opts.length) return;

    const activos = new Set(($('#sel_ra').val()||[]).map(String)); // RAs activos (por si quieres filtrar)
    $opts.each(function(){
      const id = String(this.value);
      const etiqueta = this.text || criteriosCache.get(id) || `Criterio #${id}`;
      criteriosSel.delete(id);
      // devolver a la izquierda si el criterio pertenece a algún RA activo (si no lo puedes saber, se repondrá en próximas cargas)
      if(!$('#sel_criterios_av option[value="'+id+'"]').length){
        $av.append(new Option(etiqueta, id));
      }
      $(this).remove();
    });
    aplicarFiltroDisponibles();
  }

  function removeTodos(){
    criteriosSel.clear();
    $('#sel_criterios_sel').empty();
    // Recarga disponibles para los RA activos
    cargarCriteriosDisponibles();
  }

  // ---- Guardar instrumento (usa instrumentos_bulk_save.php) ----
  function guardarInstrumento(){
    const payload = {
      id: null,
      id_modulo: idModulo(),
      anno: annoActual(),
      titulo: ($('#i_titulo').val()||'').trim(),
      descripcion: ($('#i_descripcion').val()||'').trim(),
      fecha: $('#i_fecha').val() || null,
      trimestre: parseInt($('#i_trimestre').val(),10),
      ponderacion: $('#i_ponderacion').val()? parseInt($('#i_ponderacion').val(),10) : null,
      criterios: Array.from(criteriosSel).map(Number),
      asignar_todos: $('#i_asignar_todos').is(':checked'),
      alumnos: ($('#sel_alumnos').val()||[]).map(Number)
    };

    if(!payload.id_modulo){ alert('Selecciona un módulo.'); return; }
    if(!payload.anno){ alert('Indica el año académico.'); return; }
    if(!payload.titulo){ alert('Indica un título.'); return; }
    if(payload.criterios.length===0 && !confirm('No hay criterios seleccionados. ¿Guardar igualmente?')) return;

    $('#msg').text('Guardando…');

    $.ajax({
      url:'instrumentos_bulk_save.php',
      method:'POST',
      data: JSON.stringify(payload),
      contentType:'application/json; charset=utf-8',
      dataType:'json'
    }).done(resp=>{
      if(!resp.ok){ $('#msg').text(resp.error || 'No se pudo guardar'); return; }
      $('#msg').text('Instrumento guardado correctamente.');
      // Limpieza mínima tras guardar
      criteriosSel.clear();
      renderSeleccionados();
      cargarCriteriosDisponibles();
      // (Opcional) limpiar campos
      // $('#i_titulo,#i_descripcion,#i_fecha,#i_ponderacion').val('');
 
    
    
    
    
  }).fail((xhr)=>{
  const msg = xhr?.responseText ? xhr.responseText : 'Error de red/servidor al guardar.';
  console.error('Guardar instrumento: ', xhr.status, msg);
  $('#msg').text(msg);
});

  }

  // ---- Eventos ----
  $(function(){
    // Cambios de módulo: resetea selección y carga RA/alumnos
    $('#f_modulo').on('change', function(){
      criteriosSel.clear();
      criteriosCache.clear();           // al cambiar de módulo limpiamos cache
      $('#sel_criterios_sel').empty();
      $('#sel_criterios_av').empty();
      cargarRA();
      cargarAlumnos();
    });

    // Cambios de año: recarga alumnos (no toca selección)
    $('#f_anno').on('change', cargarAlumnos);

    // Cambios de RA: solo refresca la izquierda (la derecha se mantiene)
    $('#sel_ra').on('change', cargarCriteriosDisponibles);

    // Filtro izquierda
    $('#filtro_av').on('input', aplicarFiltroDisponibles);

    // Botones mover
    $('#btn_add').on('click', addSeleccionados);
    $('#btn_add_all').on('click', addTodos);
    $('#btn_remove').on('click', removeSeleccionados);
    $('#btn_remove_all').on('click', removeTodos);

    // Doble clic
    $('#sel_criterios_av').on('dblclick', addSeleccionados);
    $('#sel_criterios_sel').on('dblclick', removeSeleccionados);

    // Asignación todos / concretos
    $('#i_asignar_todos').on('change', function(){
      $('#sel_alumnos').prop('disabled', $(this).is(':checked'));
    });

    // Guardar
    $('#btn_guardar').on('click', guardarInstrumento);
  });

})(jQuery, window, document);

