<?php
session_start();
require_once 'includes/db.php';

if (isset($_POST['id_resultado'], $_POST['bloque']) && is_numeric($_POST['id_resultado']) && is_numeric($_POST['bloque'])) {

    $id_resultado = (int) $_POST['id_resultado'];
    $id_bloque = (int) $_POST['bloque'];

    // Suponiendo que tienes una tabla para guardar las relaciones
    $stmt = $conn->prepare("INSERT INTO resultados_bloques (id_resultado, id_bloque) VALUES (:id_resultado, :id_bloque)");
    $stmt->bindParam(':id_resultado', $id_resultado, PDO::PARAM_INT);
    $stmt->bindParam(':id_bloque', $id_bloque, PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo "✅ Relación guardada correctamente.";
    } else {
        echo "❌ Error al guardar.";
    }

} else {
    echo "❌ Datos inválidos.";
}
?>
