<?php
session_start();
require_once 'includes/db.php';

if (!isset($_GET['id']) || !ctype_digit((string)$_GET['id'])) {
    echo "ID inválido.";
    exit;
}
$id = (int)$_GET['id'];

$stmt = $conn->prepare("SELECT * FROM modulos WHERE id = :id");
$stmt->bindValue(':id', $id, PDO::PARAM_INT);
$stmt->execute();
$modulo = $stmt->fetch();

if (!$modulo) {
    echo "Módulo no encontrado.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Módulo: <?php echo htmlspecialchars($modulo['nombre']); ?></title>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<style>
body{font-family:system-ui,Segoe UI,Roboto,Arial,sans-serif;margin:20px;}
.wrapper{border:1px solid #ddd;padding:12px;margin:12px 0;border-radius:8px;background:#fafafa}
ul{margin-top:8px}
button{cursor:pointer}
.btn-criterio,.btn-ra{margin:8px 6px 8px 0}
li{margin:6px 0}
label{font-weight:600}
.actions{margin:8px 0}
</style>
</head>
<body>

<?php if (file_exists('menu.php')) { require 'menu.php'; } ?>

<h1>Módulo: <?php echo htmlspecialchars($modulo['nombre']); ?></h1>

<div class="actions">
  <button class="btn-ra" id="btn-add-ra" data-id-modulo="<?php echo (int)$modulo['id']; ?>">
    Añadir resultado de aprendizaje
  </button>
</div>

<h2>Resultados de aprendizaje y criterios de evaluación</h2>

<?php
$stmt = $conn->prepare("SELECT * FROM resultados_aprendizaje WHERE id_modulo = :id_modulo ORDER BY id");
$stmt->bindValue(':id_modulo', $modulo['id'], PDO::PARAM_INT);
$stmt->execute();

while ($resultado = $stmt->fetch()):
    $ce = $conn->prepare("SELECT * FROM criterios_evaluacion WHERE id_resultados_aprendizaje = :idra ORDER BY id");
    $ce->bindValue(':idra', $resultado['id'], PDO::PARAM_INT);
    $ce->execute();
?>
<div class="wrapper" data-ra="<?php echo $resultado['id']; ?>">
  <h3>
    <?php echo htmlspecialchars($resultado['descripcion']); ?>
  </h3>

  <div class="actions">
    <button class="btn-ra btn-editar-ra" data-id="<?php echo $resultado['id']; ?>">Editar RA</button>
    <button class="btn-ra btn-borrar-ra" data-id="<?php echo $resultado['id']; ?>">Borrar RA</button>
    <button class="btn-criterio" data-id="<?php echo $resultado['id']; ?>">Añadir criterio</button>
  </div>

  <ul id="lista-criterios-<?php echo $resultado['id']; ?>">
    <?php while ($criterio = $ce->fetch()): ?>
      <li data-id="<?php echo $criterio['id']; ?>">
        <?php echo htmlspecialchars($criterio['criterio']); ?>
        <button class="btn-editar" data-id="<?php echo $criterio['id']; ?>">Editar</button>
        <button class="btn-borrar" data-id="<?php echo $criterio['id']; ?>">Borrar</button>
      </li>
    <?php endwhile; ?>
  </ul>
</div>
<?php endwhile; ?>

<!-- Diálogo para añadir/editar CRITERIO -->
<div id="dialog-form" title="Añadir/Editar Criterio" style="display:none;">
  <form id="form-criterio">
    <input type="hidden" id="id_resultado" name="id_resultado">
    <input type="hidden" id="id_criterio" name="id_criterio">
    <label for="criterio">Criterio:</label><br>
    <textarea name="criterio" id="criterio" style="width:100%;height:120px;"></textarea><br><br>
    <input type="submit" value="Guardar">
  </form>
</div>

<!-- Diálogo para añadir/editar RESULTADO DE APRENDIZAJE (RA) -->
<div id="dialog-ra" title="Añadir/Editar Resultado de Aprendizaje" style="display:none;">
  <form id="form-ra">
    <input type="hidden" id="id_modulo" name="id_modulo" value="<?php echo (int)$modulo['id']; ?>">
    <input type="hidden" id="id_ra" name="id_ra">
    <label for="descripcion_ra">Descripción del resultado:</label><br>
    <textarea name="descripcion" id="descripcion_ra" style="width:100%;height:140px;"></textarea><br><br>
    <input type="submit" value="Guardar">
  </form>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function () {
  // ========= Diálogos =========
  $("#dialog-form").dialog({ autoOpen:false, modal:true, width:480 });
  $("#dialog-ra").dialog({ autoOpen:false, modal:true, width:520 });

  // ========= RA: Añadir =========
  $("#btn-add-ra").on("click", function () {
    $("#id_ra").val('');
    $("#descripcion_ra").val('');
    $("#dialog-ra").dialog("open");
  });

  // ========= RA: Editar =========
  $(document).on("click", ".btn-editar-ra", function () {
    const id = $(this).data("id");
    $.ajax({
      url: "obtener_ra.php",
      method: "POST",
      data: { id },
      dataType: "json",
      success: function (r) {
        if (r && !r.error) {
          $("#id_ra").val(r.id);
          $("#id_modulo").val(r.id_modulo);
          $("#descripcion_ra").val(r.descripcion);
          $("#dialog-ra").dialog("open");
        } else {
          alert(r.error || "No se pudo cargar el resultado");
        }
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert("Error al obtener el resultado.");
      }
    });
  });

  // ========= RA: Borrar =========
  $(document).on("click", ".btn-borrar-ra", function () {
    if (!confirm("¿Seguro que quieres borrar este resultado y sus criterios?")) return;
    const id = $(this).data("id");
    $.ajax({
      url: "borrar_ra.php",
      method: "POST",
      data: { id },
      dataType: "json",
      success: function (r) {
        alert(r.mensaje || "Resultado borrado");
        location.reload();
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert("Error al borrar el resultado.");
      }
    });
  });

  // ========= RA: Guardar/Actualizar =========
  $("#form-ra").on("submit", function (e) {
    e.preventDefault();
    $.ajax({
      url: "guardar_ra.php",
      method: "POST",
      data: $(this).serialize(),
      dataType: "json",
      success: function (r) {
        if (r.error) { alert(r.error); return; }
        alert(r.mensaje || "Guardado");
        location.reload();
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert("Error al guardar el resultado.");
      }
    });
  });

  // ========= Criterios (lo que ya tenías) =========
  $(".btn-criterio").on("click", function () {
    $("#id_resultado").val($(this).data("id"));
    $("#id_criterio").val('');
    $("#criterio").val('');
    $("#dialog-form").dialog("open");
  });

  $(document).on("click", ".btn-editar", function () {
    const id = $(this).data("id");
    $.ajax({
      url: "obtener_criterio.php",
      method: "POST",
      data: { id },
      dataType: "json",
      success: function (r) {
        if (r && !r.error) {
          $("#id_resultado").val(r.id_resultados_aprendizaje);
          $("#id_criterio").val(r.id);
          $("#criterio").val(r.criterio);
          $("#dialog-form").dialog("open");
        } else {
          alert(r.error || "No se pudo cargar el criterio");
        }
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert("Error al obtener el criterio.");
      }
    });
  });

  $(document).on("click", ".btn-borrar", function () {
    if (!confirm("¿Seguro que quieres borrar este criterio?")) return;
    const id = $(this).data("id");
    $.ajax({
      url: "borrar_criterio.php",
      method: "POST",
      data: { id },
      dataType: "json",
      success: function (r) {
        alert(r.mensaje || "Borrado");
        location.reload();
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert("Error al borrar.");
      }
    });
  });

  $("#form-criterio").on("submit", function (e) {
    e.preventDefault();
    $.ajax({
      url: "guardar_criterio.php",
      method: "POST",
      data: $(this).serialize(),
      dataType: "json",
      success: function (r) {
        if (r.error) { alert(r.error); return; }
        alert(r.mensaje || "Guardado");
        location.reload();
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert("Error al guardar.");
      }
    });
  });
});
</script>

</body>
</html>
