<?php
// draft_set_meta.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';
function jerr($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$draft_id = (int)($in['draft_id'] ?? 0);
if($draft_id<=0) jerr('draft_id requerido');

$fields = ['titulo','descripcion','fecha','trimestre','ponderacion','asignar_todos','anno'];
$set = []; $args=[];
foreach($fields as $f){
  if(array_key_exists($f,$in)){
    $set[] = "$f = ?";
    $args[] = $in[$f];
  }
}
if(empty($set)) jerr('Nada que actualizar');

try{
  $pdo = pdo_conn();
 
  
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);  // <-- ponlo así

  $args[] = $draft_id;
  $sql = "UPDATE instrumentos_drafts SET ".implode(',',$set)." WHERE id=?";
  $st = $pdo->prepare($sql); $st->execute($args);
  echo json_encode(['ok'=>true]);
}catch(Throwable $e){ jerr($e->getMessage(),500); }
