<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/includes/db.php';

$id_modulo = isset($_GET['id_modulo']) ? (int)$_GET['id_modulo'] : 0;
$ra  = $_GET['ra']  ?? [];
$ids = $_GET['ids'] ?? [];

$ra  = is_array($ra)  ? array_map('intval',$ra)  : (strlen((string)$ra)? [(int)$ra] : []);
$ids = is_array($ids) ? array_map('intval',$ids) : (strlen((string)$ids)? [(int)$ids] : []);

if ($id_modulo <= 0) { http_response_code(400); echo json_encode([]); exit; }

$pdo = pdo_conn();

/* Tablas de tu BD:
   - criterios_evaluacion (id, id_resultados_aprendizaje, criterio, valor)
   - resultados_aprendizaje (id, id_modulo, descripcion)
   No hay "codigo" de RA; generamos 'RA ' + ra.id como codigo_ra. */

$where = " ra.id_modulo = ? ";
$params = [$id_modulo];

if (!empty($ra)) {
  $in = implode(',', array_fill(0, count($ra), '?'));
  $where .= " AND c.id_resultados_aprendizaje IN ($in) ";
  $params = array_merge($params, $ra);
}
if (!empty($ids)) {
  $in2 = implode(',', array_fill(0, count($ids), '?'));
  $where .= " AND c.id IN ($in2) ";
  $params = array_merge($params, $ids);
}

$sql = "SELECT
          c.id,
          c.criterio,
          c.valor,
          c.id_resultados_aprendizaje,
          CONCAT('RA ', ra.id) AS codigo_ra,
          ra.descripcion AS ra_descripcion
        FROM criterios_evaluacion c
        JOIN resultados_aprendizaje ra ON ra.id = c.id_resultados_aprendizaje
        WHERE $where
        ORDER BY ra.id, c.id";

$st = $pdo->prepare($sql);
$st->execute($params);
echo json_encode($st->fetchAll(PDO::FETCH_ASSOC), JSON_UNESCAPED_UNICODE);

