<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once 'includes/db.php';

try {
    if (empty($_POST['id']) || !ctype_digit((string)$_POST['id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'ID inválido']); exit;
    }
    $id = (int)$_POST['id'];

    // Si tu FK no tiene ON DELETE CASCADE, borra primero criterios relacionados
    $conn->beginTransaction();
    $stmt = $conn->prepare("DELETE FROM criterios_evaluacion WHERE id_resultados_aprendizaje = :id");
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    $stmt2 = $conn->prepare("DELETE FROM resultados_aprendizaje WHERE id = :id");
    $stmt2->bindValue(':id', $id, PDO::PARAM_INT);
    $stmt2->execute();

    $conn->commit();
    echo json_encode(['ok' => true, 'mensaje' => 'Resultado borrado']);
} catch (Throwable $e) {
    if ($conn && $conn->inTransaction()) { $conn->rollBack(); }
    http_response_code(500);
    echo json_encode(['error' => 'Error del servidor']);
}
