<?php
// alumnos_matriculados_list.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/includes/db.php';

function bad($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m]); exit; }

$id_modulo = isset($_GET['id_modulo']) ? (int)$_GET['id_modulo'] : 0;
$anno      = isset($_GET['anno']) ? trim((string)$_GET['anno']) : '';

if ($id_modulo<=0) bad('id_modulo requerido');
// el año lo intentaremos usar si la tabla lo tiene; no abortamos si viene vacío

try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // ¿La tabla alumnos_modulos tiene la columna 'anno'?
  $hasAnno = false;
  $cols = $pdo->query("SHOW COLUMNS FROM alumnos_modulos")->fetchAll(PDO::FETCH_COLUMN, 0);
  if ($cols && in_array('anno', $cols, true)) $hasAnno = true;

  if ($hasAnno && $anno==='') {
    bad("anno requerido (p.ej. 2025/2026) porque alumnos_modulos tiene columna 'anno'");
  }

  if ($hasAnno) {
    $sql = "
      SELECT a.id, a.nombre, a.apellidos, a.apellido1, a.apellido2
      FROM alumnos_modulos am
      JOIN alumnos a ON a.id = am.id_alumno
      WHERE am.id_modulo = :id_modulo AND am.anno = :anno
      ORDER BY a.apellidos, a.apellido1, a.nombre
    ";
    $st = $pdo->prepare($sql);
    $st->execute([':id_modulo'=>$id_modulo, ':anno'=>$anno]);
  } else {
    // Sin columna 'anno': filtramos sólo por módulo
    $sql = "
      SELECT a.id, a.nombre, a.apellidos, a.apellido1, a.apellido2
      FROM alumnos_modulos am
      JOIN alumnos a ON a.id = am.id_alumno
      WHERE am.id_modulo = :id_modulo
      ORDER BY a.apellidos, a.apellido1, a.nombre
    ";
    $st = $pdo->prepare($sql);
    $st->execute([':id_modulo'=>$id_modulo]);
  }

  echo json_encode($st->fetchAll(PDO::FETCH_ASSOC));
}catch(Throwable $e){
  bad($e->getMessage(), 500);
}

