<?php
// diag_estructura_alumnos.php
require_once 'includes/db.php';

// Fuerza excepciones por si en db.php no está activado
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$requeridas = [
  'id','nre','expediente','nombre','apellidos','apellido1','apellido2',
  'dni','curso','grupo','subgrupo','fecha_nacimiento','telefono','telefono2',
  'email_personal','email_oficial'
];

echo "<h2>Comprobación de columnas en alumnos</h2>";

$cols = $conn->query("SHOW COLUMNS FROM alumnos")->fetchAll(PDO::FETCH_COLUMN, 0);
$faltan = array_values(array_diff($requeridas, $cols));
$extras = array_values(array_diff($cols, $requeridas));

echo "<p><b>Columnas existentes:</b> ".htmlspecialchars(implode(', ', $cols))."</p>";

if ($faltan) {
  echo "<p style='color:#b91c1c'><b>FALTAN:</b> ".htmlspecialchars(implode(', ', $faltan))."</p>";
  echo "<p>Ejecuta el ALTER TABLE que te pasé para añadirlas.</p>";
} else {
  echo "<p style='color:#14532d'><b>OK:</b> están todas las columnas requeridas.</p>";
}

if ($extras) {
  echo "<p><b>Columnas extra (no usadas por el importador):</b> ".htmlspecialchars(implode(', ', $extras))."</p>";
}

// Comprobar índices únicos recomendados
echo "<h3>Índices únicos</h3>";
$idx = $conn->query("SHOW INDEX FROM alumnos")->fetchAll(PDO::FETCH_ASSOC);
$indices = [];
foreach ($idx as $i) {
    $indices[$i['Key_name']][] = $i['Column_name'];
}
$hayNRE = isset($indices['uq_alumnos_nre']) && in_array('nre', $indices['uq_alumnos_nre']);
$hayEXP = isset($indices['uq_alumnos_expediente']) && in_array('expediente', $indices['uq_alumnos_expediente']);

echo "<p>NRE único: ".($hayNRE ? "Sí" : "No")."</p>";
echo "<p>EXPEDIENTE único: ".($hayEXP ? "Sí" : "No")."</p>";
