<?php
// alumnos_autocomplete.php — devuelve TODOS los campos de la tabla alumnos
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

try {
    require_once __DIR__ . '/includes/db.php'; // debe exponer $conn o $pdo (PDO)

    /** @var PDO $db */
    if (isset($conn) && $conn instanceof PDO) {
        $db = $conn;
    } elseif (isset($pdo) && $pdo instanceof PDO) {
        $db = $pdo;
    } else {
        throw new RuntimeException('No hay conexión PDO ($conn o $pdo)');
    }

    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);
    $db->exec("SET NAMES utf8mb4");

    $term  = isset($_GET['term']) ? trim((string)$_GET['term']) : '';
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
    if ($limit < 1 || $limit > 50) { $limit = 20; }

    if ($term === '') {
        echo '[]';
        exit;
    }

    $limitSql = (string)$limit;
    $like = '%' . $term . '%';

    // Pedimos todas las columnas de la tabla
    $sql = "
        SELECT
            id,
            anno,
            nre,
            expediente,
            nombre,
            apellidos,
            apellido1,
            apellido2,
            dni,
            curso,
            grupo,
            subgrupo,
            fecha_nacimiento,
            telefono,
            telefono2,
            email_personal,
            email_oficial
        FROM alumnos
        WHERE
            nombre LIKE :like
            OR apellidos LIKE :like
            OR dni LIKE :like
            OR nre LIKE :like
            OR expediente LIKE :like
        ORDER BY apellidos IS NULL, apellidos ASC, nombre IS NULL, nombre ASC
        LIMIT {$limitSql}
    ";

    $st = $db->prepare($sql);
    $st->bindValue(':like', $like, PDO::PARAM_STR);
    $st->execute();

    $rows = $st->fetchAll(PDO::FETCH_ASSOC);

    $out = [];
    foreach ($rows as $r) {
        $ap = (string)($r['apellidos'] ?? '');
        $no = (string)($r['nombre'] ?? '');
        $label = trim($ap . ($ap && $no ? ', ' : '') . $no);
        if ($label === '') {
            $label = 'ID ' . (string)$r['id'];
        }

        // Siempre incluir los campos que jQuery UI necesita
        $item = [
            'id'    => (int)$r['id'],
            'label' => $label,
            'value' => $label,
        ];

        // Añadir todos los demás campos tal cual
        foreach ($r as $k => $v) {
            if (!array_key_exists($k, $item)) {
                $item[$k] = $v;
            }
        }

        $out[] = $item;
    }

    echo json_encode($out, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

} catch (Throwable $e) {
    // error_log($e->getMessage());
    echo '[]';
}

