<?php
// alumno_matriculas_diag.php (DIAGNÓSTICO)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors','1'); ini_set('display_startup_errors','1'); error_reporting(E_ALL);

try {
  require_once __DIR__ . '/includes/db.php';

  if (isset($_GET['ping'])) { echo json_encode(['ok'=>true,'dir'=>__DIR__, 'php'=>PHP_VERSION]); exit; }

  $id_alumno = isset($_GET['id_alumno']) ? (int)$_GET['id_alumno'] : 0;
  $anno      = isset($_GET['anno']) ? trim((string)$_GET['anno']) : '';
  if ($id_alumno <= 0) { http_response_code(400); echo json_encode(['error'=>'id_alumno requerido']); exit; }

  $sqlBase = "SELECT am.id, am.id_alumno, am.id_modulo, am.anno, am.fecha,
                     COALESCE(m.nombre,'(sin nombre)') AS modulo_nombre
              FROM alumnos_modulos am
              LEFT JOIN modulos m ON m.id = am.id_modulo
              WHERE am.id_alumno = :id_alumno";
  $params = [':id_alumno' => $id_alumno];
  if ($anno !== '') { $sqlBase .= " AND am.anno = :anno"; $params[':anno'] = $anno; }
  $sqlBase .= " ORDER BY am.anno DESC, modulo_nombre ASC";

  if (isset($pdo) && $pdo instanceof PDO) {
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $st = $pdo->prepare($sqlBase);
    foreach ($params as $k=>$v) $st->bindValue($k,$v);
    $st->execute();
    echo json_encode($st->fetchAll(PDO::FETCH_ASSOC) ?: []);
    exit;
  }

  if (isset($conn) && $conn instanceof mysqli) {
    $sql = str_replace([':id_alumno', ':anno'], ['?', '?'], $sqlBase);
    $types = 'i'; $bind = [$id_alumno];
    if ($anno !== '') { $types .= 's'; $bind[] = $anno; }

    $stmt = $conn->prepare($sql);
    if (!$stmt) throw new RuntimeException('mysqli->prepare: '.$conn->error);

    $bind_refs = []; $bind_refs[] = &$types;
    foreach ($bind as $k=>$v) $bind_refs[] = &$bind[$k];
    call_user_func_array([$stmt,'bind_param'], $bind_refs);
    if (!$stmt->execute()) throw new RuntimeException('stmt->execute: '.$stmt->error);
    $result = $stmt->get_result();
    echo json_encode($result ? $result->fetch_all(MYSQLI_ASSOC) : []);
    $stmt->close(); exit;
  }

  throw new RuntimeException('Ni $pdo ni $conn definidos en includes/db.php');

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'EXCEPTION','type'=>get_class($e),'msg'=>$e->getMessage(),'file'=>$e->getFile(),'line'=>$e->getLine()]);
}
