// alumno_instrumentos_draft.js
(function($, window, document){
  'use strict';

  const ID_MOD = window.APP?.ID_MOD || window.ID_MOD || 0;
  const ANNO   = window.APP?.ANNO   || window.ANNO   || '';
  let DRAFT_ID = null;

  // Helpers
  const option = (label, value) => `<option value="${value}">${label}</option>`;
  const annoActual = () => ($('#f_anno').length ? ($('#f_anno').val()||'').trim() : (ANNO||'').trim());

  // --- API borrador ---
  function draftStart(){
    return $.ajax({
      url:'draft_start.php', method:'POST',
      data: JSON.stringify({ id_modulo: ID_MOD, anno: annoActual() }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    }).done(r=>{
      if(!r.ok) throw new Error(r.error||'No se pudo iniciar borrador');
      DRAFT_ID = r.draft_id;
    });
  }
  function draftAdd(ids){
    return $.ajax({
      url:'draft_add_criterios.php', method:'POST',
      data: JSON.stringify({ draft_id: DRAFT_ID, ids: ids.map(Number) }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftRemove(ids){
    return $.ajax({
      url:'draft_remove_criterios.php', method:'POST',
      data: JSON.stringify({ draft_id: DRAFT_ID, ids: ids.map(Number) }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftList(){
    return $.getJSON('draft_list.php',{ draft_id: DRAFT_ID });
  }
  function draftSetMeta(meta){
    return $.ajax({
      url:'draft_set_meta.php', method:'POST',
      data: JSON.stringify(Object.assign({draft_id:DRAFT_ID}, meta)),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftSetAlumnos(asignar_todos, alumnos){
    return $.ajax({
      url:'draft_set_alumnos.php', method:'POST',
      data: JSON.stringify({ draft_id:DRAFT_ID, asignar_todos: asignar_todos?1:0, alumnos: (alumnos||[]).map(Number)}),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }
  function draftCommit(){
    return $.ajax({
      url:'draft_commit.php', method:'POST',
      data: JSON.stringify({ draft_id: DRAFT_ID }),
      contentType:'application/json; charset=utf-8', dataType:'json'
    });
  }

  // --- RA y criterios ---
  function cargarRA(){
    return $.getJSON('ra_list.php',{id_modulo:ID_MOD}).done(rows=>{
      const $ra = $('#dlg_ra').empty();
      if(!rows || !rows.length){ $ra.append('<option value="">(Sin RA)</option>'); return; }
      rows.forEach(r=>{
        const etiqueta = r.descripcion ? `${r.codigo} · ${r.descripcion}` : (r.codigo || `RA ${r.id}`);
        $ra.append(option(etiqueta, r.id));
      });
      $ra.trigger('change');
    });
  }

  function cargarDisponiblesDelRA(){
    const id_ra = $('#dlg_ra').val();
    const $av = $('#dlg_criterios_av').empty();
    if(!id_ra) return $.Deferred().resolve();

    // Trae criterios del RA actual
    return $.getJSON('criterios_list.php', { id_modulo: ID_MOD, ra: [id_ra] }).then(rows=>{
      // Trae seleccionados del borrador
      return draftList().then(dr=>{
        const sel = new Set((dr.criterios||[]).map(c=> String(c.id)));
        rows.forEach(r=>{
          if(!sel.has(String(r.id))){
            $av.append(option(`${r.codigo_ra} · ${r.criterio} (v=${r.valor})`, r.id));
          }
        });
      });
    });
  }

  function renderSeleccionados(){
    const $sel = $('#dlg_criterios_sel').empty();
    if(!DRAFT_ID){ return; }
    draftList().done(dr=>{
      (dr.criterios||[]).forEach(r=>{
        $sel.append(option(`${r.codigo_ra} · ${r.criterio} (v=${r.valor})`, r.id));
      });
    });
  }

  // --- Alumnos (para el selector opcional) ---
  function cargarAlumnosMatriculados(){
    const a = annoActual(); if(!a) return $.Deferred().reject();
    return $.getJSON('alumnos_matriculados_list.php',{id_modulo:ID_MOD, anno:a})
      .done(rows=>{
        const $s = $('#dlg_sel_alumnos').empty();
        rows.forEach(al=>{
          const nombre = [al.nombre, al.apellidos || ((al.apellido1||'')+' '+(al.apellido2||''))].filter(Boolean).join(' ');
          $s.append(option(`${nombre} (#${al.id})`, al.id));
        });
      });
  }

  // --- Eventos UI ---
  $(function(){

    $('#dlg_ra').on('change', function(){
      cargarDisponiblesDelRA().always(()=>{/* ok */});
    });

    // Añadir seleccionados del RA actual
    $('#btn_add').on('click', function(){
      const ids = ($('#dlg_criterios_av').val()||[]).map(Number);
      if(!ids.length) return;
      draftAdd(ids).done(()=>{
        // refrescar ambas listas
        cargarDisponiblesDelRA(); renderSeleccionados();
      });
    });

    // Añadir todos del RA actual
    $('#btn_add_all').on('click', function(){
      const ids = $('#dlg_criterios_av option').map((_,o)=> Number($(o).val())).get();
      if(!ids.length) return;
      draftAdd(ids).done(()=>{
        cargarDisponiblesDelRA(); renderSeleccionados();
      });
    });

    // Quitar del recuadro de la derecha
    $('#btn_remove').on('click', function(){
      const ids = ($('#dlg_criterios_sel').val()||[]).map(Number);
      if(!ids.length) return;
      draftRemove(ids).done(()=>{
        cargarDisponiblesDelRA(); renderSeleccionados();
      });
    });

    // Quitar todos
    $('#btn_remove_all').on('click', function(){
      draftRemove([]).done(()=>{ // sin ids = quitar todos (endpoint lo soporta)
        cargarDisponiblesDelRA(); renderSeleccionados();
      });
    });

    // Doble clic
    $('#dlg_criterios_av').on('dblclick', function(){ $('#btn_add').click(); });
    $('#dlg_criterios_sel').on('dblclick', function(){ $('#btn_remove').click(); });

    // Abrir diálogo
    $('#btn_dialogo_inst').on('click', function(){
      const a = annoActual();
      if(!a){ alert('Indica el año académico'); return; }

      // Reset visual
      $('#frm_dlg')[0].reset();
      $('#dlg_id').val('');
      $('#dlg_asignar_todos').prop('checked', true);
      $('#dlg_sel_alumnos').prop('disabled', true);

      // Iniciar borrador en servidor
      $.when(draftStart(), cargarRA(), cargarAlumnosMatriculados()).always(()=>{
        renderSeleccionados();
      });

      $('#dlg_inst').dialog({
        modal:true, width: 780,
        buttons: {
          'Guardar instrumento': function(){
            // Persistir metadatos y commit
            const meta = {
              titulo: $('#dlg_titulo').val().trim(),
              descripcion: $('#dlg_descripcion').val().trim(),
              fecha: $('#dlg_fecha').val() || null,
              trimestre: parseInt($('#dlg_trimestre').val(),10) || null,
              ponderacion: $('#dlg_ponderacion').val()? parseInt($('#dlg_ponderacion').val(),10) : null,
              anno: annoActual()
            };
            if(!meta.anno){ alert('Indica el año académico'); return; }
            if(!meta.titulo){ alert('Indica un título'); return; }

            const asignarTodos = $('#dlg_asignar_todos').is(':checked');
            const alumnos = ($('#dlg_sel_alumnos').val()||[]).map(Number);

            $.when(
              draftSetMeta(meta),
              draftSetAlumnos(asignarTodos, alumnos)
            ).then(draftCommit)
             .done(r=>{
                if(!r.ok){ alert(r.error||'No se pudo guardar'); return; }
                $('#dlg_inst').dialog('close');
                if(typeof window.cargarLista==='function') window.cargarLista();
             })
             .fail(()=> alert('Error guardando/confirmando el borrador'));
          },
          'Cancelar': function(){ $(this).dialog('close'); }
        }
      });
    });

    // Toggle alumnos
    $('#dlg_asignar_todos').on('change', function(){
      $('#dlg_sel_alumnos').prop('disabled', $(this).is(':checked'));
    });

  });

})(jQuery, window, document);
