<?php
// alumno_instrumentos.php
require_once __DIR__ . '/menu.php';

$id_alumno = isset($_GET['id_alumno']) ? (int)$_GET['id_alumno'] : 0;
$id_modulo = isset($_GET['id_modulo']) ? (int)$_GET['id_modulo'] : 0;
$anno      = isset($_GET['anno'])      ? (string)$_GET['anno']      : '';
if ($id_alumno<=0 || $id_modulo<=0) { http_response_code(400); echo "Faltan parámetros"; exit; }

require_once __DIR__ . '/includes/db.php';
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Instrumentos del alumno</title>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.min.js"></script>

<style>
  body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;padding:1.25rem}
  .grid{display:grid;grid-template-columns:1fr 2fr;gap:1rem;max-width:1100px}
  table{width:100%;border-collapse:collapse} th,td{padding:.5rem;border-bottom:1px solid #eee;text-align:left}
  .muted{color:#666}.field{display:flex;flex-direction:column;gap:.25rem}
  input,select,textarea{padding:.5rem;border:1px solid #ccc;border-radius:.4rem}
  .pill{display:inline-block;padding:.15rem .5rem;border:1px solid #ddd;border-radius:999px;margin:.15rem;font-size:.85rem}
  .card{border:1px solid #e5e7eb;border-radius:.6rem;padding:.75rem;background:#fafafa;margin:.75rem 0;max-width:1100px}
  .card .title{font-weight:600;margin-bottom:.25rem}
  .small{color:#555}
</style>

<!-- Exponemos parámetros a JS -->
<script>
  window.APP = {
    ID_MOD: <?= (int)$id_modulo ?>,
    ID_ALU: <?= (int)$id_alumno ?>,
    ANNO:   <?= json_encode($anno) ?>
  };
</script>
<!-- Cargamos el JS externo (versión borrador/servidor) -->
<script src="alumno_instrumentos.js?v=1"></script>
</head>

<body>
<h1>Instrumentos del alumno</h1>

<div class="muted" style="margin-bottom:.25rem">
  Alumno ID: <?= (int)$id_alumno ?> · Módulo ID: <?= (int)$id_modulo ?> · Año actual: <?= htmlspecialchars($anno ?: '—') ?>
</div>
<div class="field" style="max-width:320px;margin:.5rem 0">
  <label>Año académico</label>
  <input id="f_anno" placeholder="2025/2026" value="<?= htmlspecialchars($anno) ?>">
</div>

<?php
try{
  $pdo = pdo_conn();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // Ficha alumno
  $st = $pdo->prepare("
    SELECT id, anno, nre, expediente, nombre, apellidos, apellido1, apellido2, dni,
           curso, grupo, subgrupo, fecha_nacimiento, telefono, telefono2,
           email_personal, email_oficial
    FROM alumnos WHERE id = :id LIMIT 1
  ");
  $st->execute([':id'=>$id_alumno]);
  $a = $st->fetch(PDO::FETCH_ASSOC);

  if($a){
    $apells = $a['apellidos'] ?: trim(($a['apellido1']??'').' '.($a['apellido2']??''));
    $nombre_completo = trim(($a['nombre']??'').' '.$apells);
    echo '<div class="card">';
    echo '  <div class="title">'.h($nombre_completo).' <span class="small">(#'.(int)$a['id'].')</span></div>';
    echo '</div>';
  } else {
    echo '<div class="card"><div class="title">Alumno</div><div>No se encontró el alumno.</div></div>';
  }

  // Ficha módulo
  $stm = $pdo->prepare("SELECT id, nombre FROM modulos WHERE id = :id LIMIT 1");
  $stm->execute([':id' => $id_modulo]);
  $m = $stm->fetch(PDO::FETCH_ASSOC);

  if ($m) {
    echo '<div class="card">';
    echo '  <div class="title">Módulo: '.h($m['nombre']).' <span class="small">(#'.(int)$m['id'].')</span></div>';
    echo '</div>';
  } else {
    echo '<div class="card"><div class="title">Módulo</div><div>No se encontró el módulo.</div></div>';
  }

} catch (Throwable $e) {
  echo '<div class="card"><div class="title">Error</div><div class="small">'.h($e->getMessage()).'</div></div>';
}
?>

<div style="margin-top:.5rem;">
  <button id="btn_dialogo_inst">Crear/editar instrumento (emergente)</button>
</div>

<!-- Diálogo emergente -->
<div id="dlg_inst" title="Instrumento de evaluación" style="display:none">
  <form id="frm_dlg" autocomplete="off">
    <input type="hidden" id="dlg_id">

    <div class="field"><label>Título</label><input id="dlg_titulo" required></div>
    <div class="field"><label>Descripción</label><textarea id="dlg_descripcion" rows="3"></textarea></div>

    <div class="grid" style="grid-template-columns:1fr 1fr; gap:0.75rem">
      <div class="field">
        <label>Fecha</label><input id="dlg_fecha" type="date">
      </div>
      <div class="field">
        <label>Trimestre</label>
        <select id="dlg_trimestre"><option value="1">1º</option><option value="2">2º</option><option value="3">3º</option></select>
      </div>
    </div>

    <div class="field"><label>Ponderación (0-100)</label><input id="dlg_ponderacion" type="number" min="0" max="100"></div>

    <hr>

    <div class="field">
      <label>Resultado de aprendizaje</label>
      <select id="dlg_ra"></select>
      <div class="muted">Elige un RA y mueve criterios al recuadro de la derecha.</div>
    </div>

    <div class="grid" style="grid-template-columns:1fr auto 1fr; gap:0.75rem; align-items:start">
      <div class="field">
        <label>Criterios disponibles</label>
        <input id="filtro_av" placeholder="Filtrar…" style="margin-bottom:.25rem">
        <select id="dlg_criterios_av" multiple size="10" style="width:100%"></select>
      </div>

      <div class="field" style="align-items:center;justify-content:center;gap:.4rem; padding-top:1.25rem">
        <button type="button" id="btn_add">&raquo; Añadir</button>
        <button type="button" id="btn_add_all">&raquo;&raquo; Añadir todos</button>
        <button type="button" id="btn_remove">&laquo; Quitar</button>
        <button type="button" id="btn_remove_all">&laquo;&laquo; Quitar todos</button>
      </div>

      <div class="field">
        <label>Criterios seleccionados</label>
        <select id="dlg_criterios_sel" multiple size="10" style="width:100%"></select>
      </div>
    </div>

    <hr>
    <div class="field">
      <label><input type="checkbox" id="dlg_asignar_todos" checked> Asignar a todos los alumnos del módulo/año</label>
    </div>
    <div class="field">
      <label>Alumnos (si NO es a todos)</label>
      <select id="dlg_sel_alumnos" multiple size="6" disabled style="width:100%"></select>
    </div>
  </form>
</div>

</body>
</html>


